
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the scatter plot
years = np.arange(1500, 1900, 25)  # Years between 1500 and 1900, in 25-year increments
popularity = np.random.uniform(0, 100, size=len(years))  # Popularity scores between 0 and 100
periods = np.linspace(1, len(years), num=len(years))  # Representing different periods

# Labels and text
xlabel = "Year"
ylabel = "Popularity Score"
title = "Philosophical Movements Popularity Over Time"
cbar_label = "Period"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))
colors = periods  # Color by period
scatter = plt.scatter(years, popularity, c=colors, cmap="coolwarm", edgecolor='k', s=100)
plt.grid(True, linestyle='--', alpha=0.7)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
cbar = plt.colorbar(scatter)
cbar.set_label(cbar_label)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_81.pdf", bbox_inches="tight")
