
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data points
import numpy as np

np.random.seed(83)
# Imagine these as different cities and their "tourist attraction scores" over various metrics
x = np.random.randint(100, size=(20))
y = np.random.randint(100, size=(20))
sizes = 10 * np.random.randint(10, 100, size=(20))
cities = np.random.randint(100, size=(20))
title = "Tourism Popularity Across Cities"
xlabel = "Popularity Score"
ylabel = "Attraction Score"
cbar_label = "Tourist Intensity"
annotations = ["New York", "London", "Tokyo", "Paris", "Sydney"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data points
plt.figure(figsize=(10, 8))
scatter = plt.scatter(x, y, c=cities, s=sizes, alpha=0.6, cmap="viridis")

# Add colorbar with label
cbar = plt.colorbar(scatter)
cbar.set_label(cbar_label)

# Setting plot titles and labels
plt.title(title, fontsize=16)
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)

# Different color scheme and marker shapes
plt.grid(True, which="both", linestyle="--", linewidth=0.5)

# Annotate some key points
for i, label in enumerate(annotations):
    plt.annotate(
        label,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(5, 5),
        ha="center",
        fontsize=12,
        color="darkblue",
    )

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_83.pdf", bbox_inches="tight")
