
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Simulating environmental data
x = np.random.randint(100, 1000, size=(20))  # CO2 emissions in million metric tons
y = np.random.uniform(-10, 40, size=(20))  # Average temperature in degrees Celsius
sizes = np.random.uniform(1, 100, size=(20)) * 10  # Population in millions

# Text label parameters
title = "Environmental Indicators: CO2 Emissions vs Average Temperature"
xlabel = "CO2 Emissions (Million Metric Tons)"
ylabel = "Average Temperature (°C)"
legend_title = "Population Size"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 7))
colors = np.random.rand(20)  # Color by some environmental indicators

sc = plt.scatter(
    x, y, c=colors, s=sizes, alpha=0.6, cmap="coolwarm", edgecolor="k", linewidth=0.5
)
plt.colorbar(sc, label="Environmental Indicator (normalized)")
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)


# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_85.pdf", bbox_inches="tight")
