
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(0)
years = np.array([2000, 2005, 2010, 2015, 2020, 2025, 2030])
christianity_popularity = np.clip(
    np.sin(np.linspace(0, 2 * np.pi, len(years))) + np.random.normal(0, 0.1, len(years)), 
    0.4, 
    0.8
)
islam_popularity = np.clip(
    np.cos(np.linspace(0, 2 * np.pi, len(years))) + np.random.normal(0, 0.1, len(years)), 
    0.5, 
    0.9
)
hinduism_popularity = np.clip(
    np.sin(np.linspace(0, 1 * np.pi, len(years))) + np.random.normal(0, 0.1, len(years)), 
    0.3, 
    0.7
)
buddhism_popularity = np.clip(
    np.cos(np.linspace(0, 1.5 * np.pi, len(years))) + np.random.normal(0, 0.05, len(years)), 
    0.4, 
    0.9
)
titles = ["Christianity vs. Hinduism Popularity", "Islam vs. Buddhism Popularity"]
figure1_scatter_labels = ["Christianity Popularity", "Hinduism Popularity"]
figure2_scatter_labels = ["Islam Popularity", "Buddhism Popularity"]
xlabel = "Year"
ylabel = "Popularity Index"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

color_christianity = "#92c5de"
color_hinduism = "#0571b0"
color_islam = "#f4a582"
color_buddhism = "#ca0020"

# The first subplot plots Christianity and Hinduism data
ax1.scatter(
    years, 
    christianity_popularity, 
    color=color_christianity, 
    label=figure1_scatter_labels[0], 
    marker="o", 
    s=80, 
    edgecolor="black"
)
ax1.scatter(
    years, 
    hinduism_popularity, 
    color=color_hinduism, 
    label=figure1_scatter_labels[1], 
    marker="s", 
    s=80, 
    edgecolor="black"
)
ax1.set_title(titles[0], fontsize=14)
ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.legend(loc="upper right")

# The second subplot plots Islam and Buddhism data
ax2.scatter(
    years, 
    islam_popularity, 
    color=color_islam, 
    label=figure2_scatter_labels[0], 
    marker="^", 
    s=80, 
    edgecolor="black"
)
ax2.scatter(
    years, 
    buddhism_popularity, 
    color=color_buddhism, 
    label=figure2_scatter_labels[1], 
    marker="d", 
    s=80, 
    edgecolor="black"
)
ax2.set_title(titles[1], fontsize=14)
ax2.set_xlabel(xlabel, fontsize=12)
ax2.set_ylabel(ylabel, fontsize=12)
ax2.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("scatter_88.pdf", bbox_inches="tight")
