
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
philosophers = [
    "Socrates",
    "Plato",
    "Aristotle",
    "Descartes",
    "Kant",
    "Nietzsche",
    "Foucault",
    "Sartre",
]

values = {
    "Ethics": [4.9, 4.8, 4.7, 4.1, 4.6, 4.5, 4.0, 4.3],
    "Metaphysics": [4.4, 4.9, 4.8, 4.7, 4.5, 4.2, 4.1, 4.3],
    "Epistemology": [4.1, 4.0, 4.6, 4.7, 4.9, 4.4, 4.5, 4.3],
    "Aesthetics": [4.7, 4.1, 4.2, 4.0, 4.3, 4.9, 4.8, 4.5],
    "Logic": [4.5, 4.6, 4.9, 4.8, 4.2, 4.1, 4.4, 4.7],
    "Political Philosophy": [4.3, 4.7, 4.5, 4.6, 4.1, 4.0, 4.9, 4.8],
}
metrics1 = ["Ethics", "Metaphysics"]
metrics2 = ["Epistemology", "Aesthetics"]
titles = ["Philosophical Metrics Comparison", "Philosophical Disciplines Factors"]
xlabel = "Score"
ylabel = "Philosophers"
suptitle = "Philosophical Metrics Among Renowned Philosophers"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(13, 7), sharey=True)
colors1 = ["#1f78b4", "#33a02c"]
colors2 = ["#ff7f00", "#6a3d9a"]

# Plotting for ax1 - first two metrics
for metric, color in zip(metrics1, colors1):
    ax1.scatter(
        values[metric],
        philosophers,
        color=color,
        label=metric,
        marker="o",
        edgecolors="w",
        s=100,
    )

ax1.set_title(titles[0])
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend()

# Plotting for ax2 - next two metrics
for metric, color in zip(metrics2, colors2):
    ax2.scatter(
        values[metric],
        philosophers,
        color=color,
        label=metric,
        marker="s",
        edgecolors="w",
        s=100,
    )

ax2.set_title(titles[1])
ax2.set_xlabel(xlabel)
ax2.legend()

# Common settings
for ax in [ax1, ax2]:
    ax.set_yticks(range(len(philosophers)))
    ax.set_yticklabels(philosophers, fontsize=10)
    ax.grid(True, linestyle="--", alpha=0.6)
    ax.tick_params(axis="x", which="major", labelsize=9)
    ax.tick_params(axis="y", which="major", labelsize=9)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.suptitle(suptitle, fontsize=16)
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("scatter_89.pdf", bbox_inches="tight")
