
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
interventions = [
    "Cognitive Behavioral Therapy",
    "Psychodynamic Therapy",
    "Humanistic Therapy",
    "Integrative Therapy",
    "Mindfulness-Based Therapy",
    "Art Therapy",
    "Music Therapy",
    "Play Therapy",
    "Family Therapy",
]

values = {
    "Anxiety Levels": [30, 45, 35, 50, 25, 40, 20, 55, 30],
    "Depression Rates": [40, 50, 45, 55, 35, 30, 25, 60, 50],
    "Stress Levels": [70, 65, 60, 75, 55, 80, 50, 85, 60],
    "Emotional Well-being": [80, 70, 75, 65, 85, 60, 90, 55, 70],
}
categorys1 = ["Anxiety Levels", "Depression Rates"]
categorys2 = ["Stress Levels", "Emotional Well-being"]
titles = ["Mental Health Issues", "Well-being Metrics"]
xlabel = "Percentage"
ylabel = "Interventions"
super_title = "Comparison of Mental Health Intervention Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(14, 7), sharey=True)
colors1 = ["#1f77b4", "#ff7f0e"]  # Sophisticated color palette
colors2 = ["#2ca02c", "#d62728"]

# Plotting for ax1 - first two categories
for category, color in zip(categorys1, colors1):
    ax1.scatter(
        values[category],
        interventions,
        color=color,
        label=category,
        marker="o",
        edgecolor="k",
    )
ax1.set_title(titles[0])
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend()

# Plotting for ax2 - next two categories
for category, color in zip(categorys2, colors2):
    ax2.scatter(
        values[category],
        interventions,
        color=color,
        label=category,
        marker="^",
        edgecolor="k",
    )
ax2.set_title(titles[1])
ax2.set_xlabel(xlabel)
ax2.legend()

# Common settings
for ax in [ax1, ax2]:
    ax.set_yticks(range(len(interventions)))
    ax.set_yticklabels(interventions)
    ax.grid(True, linestyle="--", alpha=0.6)

fig.suptitle(super_title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout(rect=[0, 0.03, 1, 0.95])  # Adjust layout to fit suptitle
plt.savefig("scatter_91.pdf", bbox_inches="tight")
