
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
regions = [
    "North America",
    "South America",
    "Europe",
    "Africa",
    "Asia",
    "Australia",
    "Antarctica"
]
values = {
    "Education Quality": [7.8, 6.4, 8.5, 5.3, 7.0, 8.2, 4.5],
    "Healthcare Quality": [8.1, 6.8, 8.9, 5.5, 7.4, 8.1, 4.7],
    "Economic Stability": [8.0, 6.5, 8.7, 5.4, 7.2, 8.0, 4.6],
    "Public Safety": [7.9, 6.3, 8.4, 5.2, 7.1, 8.3, 4.4],
    "Environmental Quality": [7.7, 6.2, 8.3, 5.0, 6.8, 7.9, 4.3],
    "Social Equality": [7.5, 6.0, 8.1, 4.8, 6.6, 7.6, 4.2],
}
xlabel = "Regions"
ylabel = "Societal Score"
title = "Societal Indicators by Region"
subtitle = "Comparison of Different Societal Indicators Across Various Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots 2x2
fig, axs = plt.subplots(2, 2, figsize=(10, 10), sharey=True)
axes = axs.flatten()

# Colors from a pastel palette
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0", "#ffb3e6"]

# Plot each category
for ax, (category, color) in zip(axes, zip(values.keys(), colors)):
    ax.scatter(
        regions,
        values[category],
        color=color,
        label=category,
        s=100,
        edgecolor="black",
        alpha=0.7,
        marker="o",
    )
    ax.set_title(category, fontsize=12)
    ax.set_xticks(regions)
    ax.set_xticklabels(regions, rotation=45, ha="right", fontsize=10)
    ax.set_xlabel(xlabel, fontsize=10)
    ax.set_ylabel(ylabel, fontsize=10)
    ax.legend()

# Enhance style
for ax in axes:
    ax.spines["top"].set_visible(False)
    ax.spines["right"].set_visible(False)
    ax.grid(True, linestyle="--", alpha=0.5)
    ax.set_ylim(4, 9)  # Ensure all plots have the same y-axis limits

# Adding titles and subtitle
plt.suptitle(title, fontsize=14, weight="bold")
plt.figtext(0.5, 0.01, subtitle, ha="center", fontsize=12, style="italic")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("scatter_93.pdf", bbox_inches="tight")
