
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
genres = [
    "Fantasy",
    "Science Fiction",
    "Mystery",
    "Romance",
    "Horror",
    "Non-Fiction",
    "Biography",
    "Self-help",
    "Historical Fiction",
]
values = {
    "Story Quality": [4.5, 4.2, 4.3, 3.8, 4.1, 3.9, 4.0, 3.7, 4.4],
    "Character Development": [4.7, 4.1, 4.5, 4.0, 3.9, 3.8, 4.2, 3.6, 4.3],
    "Writing Style": [4.0, 4.5, 4.2, 4.1, 3.8, 4.4, 3.9, 3.5, 4.1],
    "Pacing": [4.2, 4.0, 3.8, 3.9, 4.3, 4.1, 4.0, 3.8, 4.2],
    "Immersiveness": [4.6, 4.2, 4.4, 3.9, 4.0, 4.1, 3.8, 3.7, 4.5],
    "Educational Value": [3.8, 4.0, 3.7, 3.5, 4.1, 4.5, 4.6, 4.2, 4.0],
}
xlabel = "Book Genres"
ylabel = "Rating"
xlabels_rotation = 45

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots 2x3
fig, axs = plt.subplots(2, 3, figsize=(14, 10), sharey=True)
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]
axes = axs.flatten()

# Plot each category
for ax, (category, color) in zip(axes, zip(values.keys(), colors)):
    ax.scatter(
        genres,
        values[category],
        color=color,
        label=category,
        s=100,
        edgecolor="black",
        alpha=0.75,
        marker="o",
    )
    ax.set_title(category)
    ax.set_xticks(np.arange(len(genres)))
    ax.set_xticklabels(genres, rotation=xlabels_rotation, ha="right")
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.legend()

# Enhance style
for ax in axes:
    ax.spines["top"].set_visible(False)
    ax.spines["right"].set_visible(False)
    ax.grid(True, linestyle="--", alpha=0.5)
    ax.set_ylim(0, 5)  # Ensure all plots have the same y-axis limits

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("scatter_94.pdf", bbox_inches="tight")
