
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Prepare data
x_msg = np.array([10, 20, 30, 40, 50])  # Message sizes in KB
y_msg = np.array([85, 87, 90, 92, 95])  # Delivery success rate in percentage
sizes_msg = np.random.randint(150, 350, size=len(x_msg))

x_con = np.array([100, 200, 300, 400, 500])  # Number of connections
y_con = np.array([70, 75, 80, 85, 90])  # Connection quality score
sizes_con = np.random.randint(150, 350, size=len(x_con))

x_res = np.array([0.1, 0.2, 0.3, 0.4, 0.5])  # Response time in seconds
y_res = np.array([95, 92, 88, 85, 80])  # Service level percentage
sizes_res = np.random.randint(150, 350, size=len(x_res))

labels = ["Message Delivery (msg)", "Connection Quality (con)", "Response Time (res)"]
titles = [
    "Message Delivery Performance",
    "Connection Quality Performance",
    "Response Time Performance",
]
xlabel = "Metric Value"
ylabel = "Performance (%)"
supertitle = "Communication System Performance"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots with 1 row and 3 columns
fig, axs = plt.subplots(1, 3, figsize=(15, 5))

# Define a color gradient
colors = ["teal", "coral", "gold"]
markers = ["o", "s", "D"]

# Plot each dataset in a separate subplot with gradient colors
for ax, x, y, sizes, color, marker, label, title in zip(
    axs,
    [x_msg, x_con, x_res],
    [y_msg, y_con, y_res],
    [sizes_msg, sizes_con, sizes_res],
    colors,
    markers,
    labels,
    titles,
):
    scatter = ax.scatter(
        x,
        y,
        s=sizes,
        c=np.linspace(0.1, 1, len(x)),
        cmap="viridis",
        alpha=0.6,
        label=label,
        marker=marker,
    )
    ax.plot(x, y, linestyle="--", color=color, alpha=0.7)  # Use dashes for lines
    ax.set_title(title, fontsize=14, fontweight="bold")
    ax.set_xlabel(xlabel, fontsize=12)
    ax.set_ylabel(ylabel, fontsize=12)
    ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better presentation
plt.suptitle(supertitle, fontsize=16, fontweight="bold")
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
# Show the plot
plt.savefig("scatter_98.pdf", bbox_inches="tight")
