

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Prepare data for Tourism domain
x_high_season = np.array([50, 60, 70, 80, 90])  # Tourists per Thousand (High Season)
y_high_season = np.array([500, 600, 700, 750, 800])  # Revenue in Millions (High Season)
sizes_high_season = np.random.randint(100, 300, size=len(x_high_season))

x_low_season = np.array([30, 35, 40, 45, 50])  # Tourists per Thousand (Low Season)
y_low_season = np.array([300, 350, 400, 450, 500])  # Revenue in Millions (Low Season)
sizes_low_season = np.random.randint(100, 300, size=len(x_low_season))

x_offpeak_season = np.array([10, 15, 20, 25, 30])  # Tourists per Thousand (Off-Peak Season)
y_offpeak_season = np.array([100, 200, 250, 300, 350])  # Revenue in Millions (Off-Peak Season)
sizes_offpeak_season = np.random.randint(100, 300, size=len(x_offpeak_season))

labels = ["High Season", "Low Season", "Off-Peak Season"]
titles = ["High Season Tourism", "Low Season Tourism", "Off-Peak Season Tourism"]
xlabel = "Tourists per Thousand"
ylabel = "Revenue in Millions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots with 1 row and 3 columns
fig, axs = plt.subplots(1, 3, figsize=(15, 5))

# Define a color scheme
colors = ["steelblue", "darkorange", "forestgreen"]
markers = ["o", "s", "^"]

# Plot each dataset in a separate subplot with specified colors and markers
for ax, x, y, sizes, color, label, title, marker in zip(
    axs,
    [x_high_season, x_low_season, x_offpeak_season],
    [y_high_season, y_low_season, y_offpeak_season],
    [sizes_high_season, sizes_low_season, sizes_offpeak_season],
    colors,
    labels,
    titles,
    markers,
):
    scatter = ax.scatter(
        x,
        y,
        s=sizes,
        c=np.linspace(0.1, 1, len(x)),
        cmap="winter",
        alpha=0.6,
        label=label,
        marker=marker,
        edgecolors='w'
    )
    ax.plot(x, y, linestyle="--", linewidth=1.5, color=color, alpha=0.8)  # Use dashed lines
    ax.set_title(title)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better presentation
plt.tight_layout()
# Show the plot
plt.savefig("scatter_99.pdf", bbox_inches="tight")
