
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [40.0, 25.0, 15.0, 10.0, 5.0, 5.0]
labels = [
    "Party A\n40.0%",
    "Party B\n25.0%",
    "Party C\n15.0%",
    "Party D\n10.0%",
    "Party E\n5.0%",
    "Party F\n5.0%",
]

title = "Parliament Seat Distribution (2023)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 9))
colors = ["#FFD700", "#87CEEB", "#4682B4", "#808080", "#A52A2A", "#FF6347"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 18, "weight": "bold"},
    ec="white",
)

# Set title
plt.title(title, fontsize=24, weight='bold')

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_29.pdf", bbox_inches="tight")
