
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [50, 20, 15, 10, 3, 2]
labels = [
    "Software Sales 50%",
    "Hardware Sales 20%",
    "Consulting Services 15%",
    "Subscription Services 10%",
    "Advertising 3%",
    "Other 2%",
]

# Text labels
title = "Revenue Sources for a Tech Company"
supertitle = "Tech Company Financial Overview"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 8))

colors = ["#1f77b4", "#2ca02c", "#ff7f0e", "#d62728", "#9467bd", "#8c564b"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 14, "color": "black"},
    ec="white",
)

# Remove axes
plt.axis("off")

# Add titles
plt.title(title, fontsize=18, fontweight="bold")
plt.suptitle(supertitle, fontsize=20, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_30.pdf", bbox_inches="tight")
