

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [30.0, 25.0, 20.0, 10.0, 7.0, 5.0, 2.0, 1.0]
labels = [
    "Solar\n30.0%",
    "Wind\n25.0%",
    "Hydropower\n20.0%",
    "Geothermal\n10.0%",
    "Biomass\n7.0%",
    "Wave and Tidal\n5.0%",
    "Nuclear\n2.0%",
    "Other\n1.0%",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors =[
    "#66c2a5",
    "#fc8d62",
    "#8da0cb",
    "#e78ac3",
    "#a6d854",
    "#ffd92f",
    "#e5c494",
    "#b3b3b3",
]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes, label=labels, color=colors, alpha=0.8, text_kwargs={"fontsize": 18, "fontweight": "bold"}
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_36.pdf", bbox_inches="tight")

