
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data representing percentage of tourists visiting different attractions
sizes = [25.00, 20.00, 18.00, 15.00, 10.00, 7.00, 3.00, 2.00]
labels = [
    "Museums\n25.00%",
    "Parks\n20.00%",
    "Historical Sites\n18.00%",
    "Beaches\n15.00%",
    "Theme Parks\n10.00%",
    "Zoos\n7.00%",
    "Shopping Malls\n3.00%",
    "Other\n2.00%",
]

# Chart title and annotations (put in part 2 as required)
title = "Tourist Attractions by Visit Percentage"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#1f78b4",  # Museums
    "#a6cee3",  # Parks
    "#b2df8a",  # Historical Sites
    "#33a02c",  # Beaches
    "#fb9a99",  # Theme Parks
    "#e31a1c",  # Zoos
    "#fdbf6f",  # Shopping Malls
    "#cab2d6",  # Other
]

# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes, label=labels, color=colors, alpha=0.8, text_kwargs={"fontsize": 18}
)

# Set title
plt.title(title, fontsize=22)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_39.pdf", bbox_inches="tight")
