
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [40.00, 18.00, 15.00, 10.00, 8.00, 5.00, 4.00]
labels = [
    "Organic Waste\n40.00%",
    "Plastics\n18.00%",
    "Paper\n15.00%",
    "Metals\n10.00%",
    "Glass\n8.00%",
    "Textiles\n5.00%",
    "Electronic Waste\n4.00%",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Colors for waste types
colors = [
    "#FFCC00",  # Organic Waste - Yellow
    "#66CCFF",  # Plastics - Light Blue
    "#33CC33",  # Paper - Green
    "#9999FF",  # Metals - Light Purple
    "#666666",  # Glass - Grey
    "#FF6666",  # Textiles - Light Red
    "#FF9900",  # Electronic Waste - Orange
]

# Create a treemap
squarify.plot(
    sizes=sizes, label=labels, color=colors, alpha=0.8, text_kwargs={"fontsize": 18}
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_40.pdf", bbox_inches="tight")
