
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [28.00, 25.00, 15.00, 12.00, 10.00, 6.00, 3.00, 1.00]
labels = [
    "Apple\n28.00%", 
    "Samsung\n25.00%", 
    "Huawei\n15.00%", 
    "Xiaomi\n12.00%", 
    "Oppo\n10.00%", 
    "Vivo\n6.00%", 
    "OnePlus\n3.00%", 
    "Google\n1.00%",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

colors = [
    "#1f77b4",  # Apple
    "#ff7f0e",  # Samsung
    "#2ca02c",  # Huawei
    "#d62728",  # Xiaomi
    "#9467bd",  # Oppo
    "#8c564b",  # Vivo
    "#e377c2",  # OnePlus
    "#7f7f7f",  # Google
]

# Create a treemap
squarify.plot(
    sizes=sizes, label=labels, color=colors, alpha=0.8, text_kwargs={"fontsize": 18}
)

# Remove axes
plt.axis("off")

# Set the title
plt.title("Market Share of Smartphone Brands", fontsize=24)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_41.pdf", bbox_inches="tight")
