
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [35.5, 25.0, 15.5, 10.0, 7.5, 4.0, 2.5]
labels = [
    "Party A\n35.5%",
    "Party B\n25.0%",
    "Party C\n15.5%",
    "Party D\n10.0%",
    "Party E\n7.5%",
    "Party F\n4.0%",
    "Others\n2.5%",
]

title = 'Political Parties Market Share'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Modern color palette
colors = ["#3366cc", "#dc3912", "#ff9900", "#109618", "#990099", "#3b3eac", "#0099c6"]

# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 18, "weight": "bold", "color": "white"},
    ec="white",
)

# Add title
plt.title(title, fontsize=22, weight="bold", color="gray")

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_54.pdf", bbox_inches="tight")
