
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [25.0, 20.0, 18.0, 15.0, 12.0, 10.0]
labels = [
    "Goldman Sachs\n25.0%",
    "Morgan Stanley\n20.0%",
    "JPMorgan Chase\n18.0%",
    "Bank of America\n15.0%",
    "Citigroup\n12.0%",
    "Others\n10.0%",
]
title = 'Market Share of Investment Banks'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#FF6384", "#36A2EB", "#FFCE56", "#4BC0C0", "#9966FF", "#FF9F40"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.75,
    text_kwargs={"fontsize": 16, "weight": "bold", "color": "white"},
    ec="black",
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=24, weight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_57.pdf", bbox_inches="tight")
