
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [30.0, 24.0, 18.0, 12.0, 9.0, 7.0]
labels = [
    "Fiction\n30.0%",
    "Non-Fiction\n24.0%",
    "Mystery\n18.0%",
    "Science Fiction\n12.0%",
    "Fantasy\n9.0%",
    "Romance\n7.0%",
]
title = "Book Sales Distribution by Genre"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#66c2a5", "#fc8d62", "#8da0cb", "#e78ac3", "#a6d854", "#ffd92f"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 18, "weight": "bold"},
    ec="black",
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=22, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("tree_58.pdf", bbox_inches="tight")
