
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data - Environmental Issues Categories
sizes = [40, 25, 15, 12, 8]
labels = [
    "Climate Change - 40%",
    "Pollution - 25%",
    "Deforestation - 15%",
    "Biodiversity Loss - 12%",
    "Overfishing - 8%",
]
title = "Environmental Issues Categories Distribution"
xlabel = ""
ylabel = ""

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 9))

colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 14, "color": "white"},
    edgecolor="white",  # Improved border visibility
    linewidth=3,  # Added edge line width for better visuals
)

# Set plot title
plt.title(title, fontsize=22, color="black", weight="bold")

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_64.pdf", bbox_inches="tight")

