
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data - Legal Categories
sizes = [30, 20, 15, 15, 10, 10]
labels = [
    "Criminal Law - 30%", 
    "Civil Law - 20%", 
    "Constitutional Law - 15%", 
    "Administrative Law - 15%", 
    "International Law - 10%", 
    "Environmental Law - 10%"
]
title = "Legal Categories Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#1E90FF", "#DC143C", "#32CD32", "#FFD700", "#778899", "#8A2BE2"]

# Create a figure with the specified size
fig = plt.figure(figsize=(10, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 12, "color": "black"},
    edgecolor="white",  # Improved border visibility
    linewidth=2 # Added edge line width for better visuals
)

# Set plot title
plt.title(title, fontsize=18, color='black', weight='bold')

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_65.pdf", bbox_inches="tight")
