
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [50, 25, 15, 5, 3, 2]
labels = [
    "Primary Education",
    "Secondary Education",
    "Higher Education",
    "Vocational Training",
    "Adult Education",
    "Special Education",
]
title = "Education Sector Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Text label parameters
text_kwargs = {"fontsize": 12, "color": "white"}

colors = ["#FFCC00", "#66CC66", "#33CCFF", "#3333FF", "#FF3333", "#FF9933"]
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 6))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.7,
    text_kwargs=text_kwargs,
    ec="black",  # edge color
)

# Add title
plt.title(title, fontsize=18)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_67.pdf", bbox_inches="tight")
