
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Additional Libraries
import numpy as np

# Data
sizes = [25, 30, 20, 15, 5, 5]
labels = [
    "0-14 years\n25%",
    "15-24 years\n30%",
    "25-54 years\n20%",
    "55-64 years\n15%",
    "65-74 years\n5%",
    "75+ years\n5%",
]
title = "Population Distribution by Age Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#2E86C1", "#A569BD", "#45B39D", "#F4D03F", "#E74C3C", "#5D6D7E"]
# Create a figure with the specified size
fig = plt.figure(figsize=(8, 6))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.9,
    text_kwargs={"fontsize": 12, "color": "white"},
    ec="white",
)

# Set the title
plt.title(title, fontsize=18)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_69.pdf", bbox_inches="tight")
