
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [22, 14, 12, 11, 10, 8, 7, 6, 5]
labels = [
    "Technology\n22%",
    "Healthcare\n14%",
    "Financials\n12%",
    "Consumer Discretionary\n11%",
    "Industrials\n10%",
    "Consumer Staples\n8%",
    "Energy\n7%",
    "Utilities\n6%",
    "Real Estate\n5%"
]
title = "Market Share of S&P 500 Sectors"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#A6CEE3", "#1F78B4", "#B2DF8A", "#33A02C", 
    "#FB9A99", "#E31A1C", "#FDBF6F", "#FF7F00", "#CAB2D6"
]
# Create a figure with the specified size
fig = plt.figure(figsize=(8, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 12, "color": "white"},
    ec="white",
)

# Set the title
plt.title(title, fontsize=18)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_70.pdf", bbox_inches="tight")
