
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [30, 25, 20, 10, 8, 7]  # Representing the proportion of each sector
labels = [
    "Solar Energy\n30%",
    "Wind Energy\n25%",
    "Hydroelectric\n20%",
    "Geothermal\n10%",
    "Biomass\n8%",
    "Tidal Energy\n7%",
]
title = "Market Share of Renewable Energy Sources"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#3366cc", "#dc3912", "#ff9900", "#109618", "#990099", "#0099c6"]
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 10))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.85,
    text_kwargs={"fontsize": 14, "color": "white"},
    pad=True,
    ec="white",
)

# Add a title
plt.title(title, fontsize=20)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_76.pdf", bbox_inches="tight")
