

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sizes = [31, 24, 16, 15, 7, 7]
labels = [
    "Christianity\n31%",
    "Islam\n24%",
    "Unaffiliated\n16%",
    "Hinduism\n15%",
    "Buddhism\n7%",
    "Other Religions\n7%",
]
title = "World Religion Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#67a9cf", "#ef8a62", "#91cf60", "#dfc27d", "#f6e8c3", "#762a83"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 9))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.9,
    text_kwargs={"fontsize": 14, "color": "white", "weight": "bold"},
    pad=True,
    ec="black",
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=18, weight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_79.pdf", bbox_inches="tight")
