
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
sizes = [35.0, 25.0, 15.0, 10.0, 8.0, 5.0, 2.0]  # Example percentages
labels = [
    "Action\n35.0%",
    "Drama\n25.0%",
    "Comedy\n15.0%",
    "Horror\n10.0%",
    "Sci-Fi\n8.0%",
    "Romance\n5.0%",
    "Documentary\n2.0%",
]
title = "Box Office Revenue Distribution by Movie Genre"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 10))

colors = ["#7986CB", "#64B5F6", "#4DD0E1", "#81C784", "#FFD54F", "#FF8A65", "#A1887F"]

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 14, "color": "white", "weight": "bold"},
    pad=True,
    ec="black",
)

# Remove axes
plt.axis("off")

# Add title
plt.title(title, fontsize=18, weight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_80.pdf", bbox_inches="tight")
