
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate sample communication data
communication_methods = {
    "Method 1": {
        "Email": np.random.normal(20, 5, 100),
        "Phone Call": np.random.normal(15, 3, 100),
    },
    "Method 2": {
        "Text Message": np.random.normal(10, 2, 100),
        "Video Call": np.random.normal(25, 7, 100),
    },
    "Method 3": {
        "Email": np.random.normal(18, 4, 100),
        "Phone Call": np.random.normal(14, 3, 100),
    },
    "Method 4": {
        "Text Message": np.random.normal(9, 2, 100),
        "Video Call": np.random.normal(23, 6, 100),
    },
}

title = "Distribution of Response Times (in minutes):"
xticklabels = ["Email/Phone Call", "Text Message/Video Call"]
xticks = [1, 2]

# Prepare data for violin plot
data_to_plot = []
for method_name, methods in communication_methods.items():
    data_to_plot.extend([times for method, times in methods.items()])

# Text labels
xlabel = "Communication Methods"
ylabel = "Response Time (minutes)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and an array of axes: 2x2 subplot grid
fig, axs = plt.subplots(nrows=2, ncols=2, figsize=(12, 8))

# Define colors
colors = {
    "Email": "#ff9999",
    "Phone Call": "#66b3ff",
    "Text Message": "#99ff99",
    "Video Call": "#ffcc99",
}

# Flatten the axes array for easy iteration
axs = axs.flatten()

for i, (method_name, ax) in enumerate(zip(communication_methods, axs)):
    method_times = communication_methods[method_name]
    parts = ax.violinplot([method_times["Email"], method_times["Phone Call"]] if i % 2 == 0 else [method_times["Text Message"], method_times["Video Call"]],
                          showmeans=True, showmedians=True)
    
    # Set the colors for each part of the violin
    for pc, color in zip(parts['bodies'], [colors["Email"], colors["Phone Call"]] if i % 2 == 0 else [colors["Text Message"], colors["Video Call"]]):
        pc.set_facecolor(color)
        pc.set_edgecolor('black')
    ax.set_title(f"{title} {method_name}")
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Improve spacing between subplots
plt.tight_layout()

plt.savefig("violin_45.pdf", bbox_inches="tight")
