
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate sample data for energy consumption (in kWh)
energy_consumption = {
    "Residential": {
        "Urban": np.random.normal(350, 50, 100),
        "Rural": np.random.normal(280, 40, 100),
    },
    "Commercial": {
        "Urban": np.random.normal(450, 60, 100),
        "Rural": np.random.normal(400, 55, 100),
    },
    "Industrial": {
        "Urban": np.random.normal(500, 70, 100),
        "Rural": np.random.normal(450, 65, 100),
    },
    "Transportation": {
        "Urban": np.random.normal(320, 45, 100),
        "Rural": np.random.normal(300, 40, 100),
    },
}

title = "Energy Consumption Distribution (kWh):"
xticklabels = ["Urban", "Rural"]
xticks = [1, 2]

# Prepare data for violin plot
data_to_plot = []
for sector, consumption in energy_consumption.items():
    data_to_plot.extend([usage for _, usage in consumption.items()])

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and an array of axes: 2x2 subplot grid
fig, axs = plt.subplots(nrows=2, ncols=2, figsize=(12, 8))

# Colors for the violins
colors = ["#add8e6", "#90ee90"]

# Flatten the axes array for easy iteration
axs = axs.flatten()

for i, (sector, ax) in enumerate(zip(energy_consumption, axs)):
    consumption = energy_consumption[sector]
    parts = ax.violinplot(
        [consumption["Urban"], consumption["Rural"]], showmeans=False, showmedians=True
    )

    for pc, color in zip(parts["bodies"], colors):
        pc.set_facecolor(color)
        pc.set_edgecolor("black")
        pc.set_alpha(0.7)

    for partname in ("cbars", "cmins", "cmaxes", "cmedians"):
        vp = parts[partname]
        vp.set_edgecolor("black")
        vp.set_linewidth(1)

    ax.set_title(f"{title} {sector}")
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    ax.yaxis.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Improve spacing between subplots
plt.tight_layout()

plt.savefig("violin_46.pdf", bbox_inches="tight")
