import numpy as np; np.random.seed(0)

np.random.seed(0)

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# raw data
# data for the first person
ap1 = np.array(
    [
        [
            0.0054,
            -0.0432,
            -0.0456,
            -0.0084,
            0.0558,
            0.0222,
            0.03,
            0.0138,
            -0.0048,
            -0.033,
            -0.012,
            0.0768,
            0.0966,
            0.0822,
            -0.063,
            -0.1038,
            -0.0834,
        ],
        [
            0.0102,
            0.0702,
            0.048,
            0.0906,
            -0.0492,
            -0.0648,
            -0.0372,
            0.015,
            0.0,
            -0.0342,
            -0.0198,
            -0.0552,
            -0.1152,
            -0.1278,
            0.066,
            0.1278,
            0.081,
        ],
        [
            0.222,
            0.2556,
            -0.0612,
            -0.3162,
            0.2544,
            -0.0606,
            -0.3174,
            0.3576,
            0.501,
            0.5334,
            0.606,
            0.4872,
            0.3744,
            0.2982,
            0.489,
            0.3948,
            0.2982,
        ],
    ]
)

# data for the second person
ap2 = np.array(
    [
        [
            0.6108,
            0.5136,
            0.5088,
            0.5832,
            0.7116,
            0.6444,
            0.66,
            0.6276,
            0.5904,
            0.534,
            0.576,
            0.7536,
            0.7932,
            0.7644,
            0.474,
            0.3924,
            0.4332,
        ],
        [
            0.2604,
            0.3804,
            0.336,
            0.4212,
            0.1416,
            0.1104,
            0.1656,
            0.27,
            0.24,
            0.1716,
            0.2004,
            0.1296,
            0.0096,
            -0.0156,
            0.372,
            0.4956,
            0.402,
        ],
        [
            0.804,
            0.8712,
            0.2376,
            -0.2724,
            0.8688,
            0.2388,
            -0.2748,
            1.0752,
            1.362,
            1.4268,
            1.572,
            1.3344,
            1.1088,
            0.9564,
            1.338,
            1.1496,
            0.9564,
        ],
    ]
)


# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# data for the first person
xp = ap1[0]
yp = ap2[1]
zp = ap2[2]

# data for the second person
xp2 = ap2[0]
yp2 = ap2[1]
zp2 = ap2[2]

fig, ax = plt.subplots(figsize=(7, 7), subplot_kw={"projection": "3d"})

radius = 1
ax.set_xlim3d([0, radius])
ax.set_ylim3d([0, radius])
ax.set_zlim3d([0, radius * 1.5])
ax.view_init(elev=15.0, azim=70)
ax.dist = 7.5

# 3D scatter
ax.scatter3D(xp, yp, zp, color="darkorange", label="Targets")

# draw the body
# left leg
ax.plot(xp[0:4], yp[0:4], zp[0:4], ls="-", color="orange")
# right leg
ax.plot(
    np.hstack((xp[0], xp[4:7])),
    np.hstack((yp[0], yp[4:7])),
    np.hstack((zp[0], zp[4:7])),
    ls="-",
    color="orange",
)
# spine
ax.plot(
    np.hstack((xp[0], xp[7:11])),
    np.hstack((yp[0], yp[7:11])),
    np.hstack((zp[0], zp[7:11])),
    ls="-",
    color="orange",
)
# right arm
ax.plot(
    np.hstack((xp[8], xp[11:14])),
    np.hstack((yp[8], yp[11:14])),
    np.hstack((zp[8], zp[11:14])),
    ls="-",
    color="orange",
)
# left arm
ax.plot(
    np.hstack((xp[8], xp[14:])),
    np.hstack((yp[8], yp[14:])),
    np.hstack((zp[8], zp[14:])),
    ls="-",
    color="orange",
)

# second person
ax.scatter3D(xp2, yp2, zp2, color="blue", label="Predictions")
#
# left leg
ax.plot(xp2[0:4], yp2[0:4], zp2[0:4], ls="-", color="blue")
# right leg
ax.plot(
    np.hstack((xp2[0], xp2[4:7])),
    np.hstack((yp2[0], yp2[4:7])),
    np.hstack((zp2[0], zp2[4:7])),
    ls="-",
    color="blue",
)
# spine
ax.plot(
    np.hstack((xp2[0], xp2[7:11])),
    np.hstack((yp2[0], yp2[7:11])),
    np.hstack((zp2[0], zp2[7:11])),
    ls="-",
    color="blue",
)
# right arm
ax.plot(
    np.hstack((xp2[8], xp2[11:14])),
    np.hstack((yp2[8], yp2[11:14])),
    np.hstack((zp2[8], zp2[11:14])),
    ls="-",
    color="blue",
)
# left arm
ax.plot(
    np.hstack((xp2[8], xp2[14:])),
    np.hstack((yp2[8], yp2[14:])),
    np.hstack((zp2[8], zp2[14:])),
    ls="-",
    color="blue",
)

plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_1.pdf", bbox_inches="tight")
