import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0)

np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
x = np.array([-5.0, -4.0, -3.0, -1.0, -0.0, 1.0, 2.0, 4.0, 5.0, 6.0])
y = np.array([8.0, 7.0, 6.0, 4.0, 3.0, 2.0, 1.0, -1.0, -2.0, -3.0])
z = np.array([7.06, 2.82, 6.36, 12.63, 12.36, 2.2, 11.13, 7.95, 9.36, 12.64])
z_fit = np.array([5.99, 6.44, 6.89, 7.78, 8.23, 8.67, 9.12, 10.02, 10.46, 10.91])

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(8, 6))
ax = fig.add_subplot(111, projection="3d")

ax.scatter(x, y, z, color="r", label="Discrete Points", marker="o")
ax.plot(x, y, z_fit, color="b", label="Fit Line")

ax.set_xlabel("Temperature (°C)")
ax.set_ylabel("Pressure (kPa)")
ax.set_zlabel("Volume (L)")
ax.legend()

ax.set_box_aspect(aspect=None, zoom=0.8)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_12.pdf", bbox_inches="tight")
