import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0)

np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================

yticklabels = ["BMW", "Audi"]
years = np.array([2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019])
bmw = np.array([0.98, 0.8, 0.46, 0.78, 0.12, 0.64, 0.14, 0.94, 0.52, 0.41])
audi = np.array([0.16, 0.11, 0.66, 0.14, 0.2, 0.37, 0.82, 0.1, 0.84, 0.1])
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(8, 6))
ax = fig.add_subplot(projection="3d")

ax.bar(years, bmw, zs=0, zdir="y", color="sandybrown", alpha=0.8)
ax.bar(years, audi, zs=1, zdir="y", color="skyblue", alpha=0.8)

ax.set_xlabel("Year")
ax.set_ylabel("Type")
ax.set_zlabel("Profit Ratio")

ax.set_yticks([0, 1])
ax.set_yticklabels(yticklabels)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_13.pdf", bbox_inches="tight")
