import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0)

np.random.seed(0)
# ===================
# Part 2: Data Preparation
# ===================
red = np.array(
    [
        [24.0, 30.0, 21.0, 16.0, 18.0, 27.0, 32.0, 32.0, 27.0, 25.0],
        [46.0, 46.0, 52.0, 52.0, 57.0, 58.0, 40.0, 48.0, 41.0, 50.0],
        [-38.0, -34.0, -33.0, -45.0, -38.0, -36.0, -33.0, -35.0, -38.0, -40.0],
    ]
)
blue = np.array(
    [
        [29.0, 29.0, 33.0, 22.0, 33.0, 32.0, 30.0, 33.0, 33.0, 31.0],
        [103.0, 85.0, 105.0, 82.0, 94.0, 68.0, 74.0, 71.0, 77.0, 74.0],
        [-33.0, -21.0, -27.0, -31.0, -17.0, -18.0, -19.0, -30.0, -29.0, -16.0],
    ]
)
orange = np.array(
    [
        [24.0, 19.0, 21.0, 26.0, 23.0, 11.0, 19.0, 18.0, 19.0, 16.0],
        [27.0, 28.0, 25.0, 30.0, 13.0, 14.0, 17.0, 26.0, 28.0, 23.0],
        [-53.0, -39.0, -41.0, -46.0, -38.0, -51.0, -49.0, -42.0, -37.0, -39.0],
    ]
)
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(8, 6))
ax = fig.add_subplot(projection="3d")

ax.scatter(red[0], red[1], red[2], marker="o", color="red", depthshade=False)
ax.scatter(blue[0], blue[1], blue[2], marker="^", color="blue", depthshade=False)
ax.scatter(
    orange[0], orange[1], orange[2], marker="s", color="orange", depthshade=False
)
ax.set_xlabel("Age")
ax.set_ylabel("Income")
ax.set_zlabel("Debt")

ax.set_xticks([10, 15, 20, 25, 30, 35, 40])
ax.set_yticks([10, 30, 50, 70, 90])
ax.set_zticks([-50, -40, -30, -20])

ax.set_box_aspect(aspect=None, zoom=0.8)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_8.pdf", bbox_inches="tight")
