import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)
from scipy.stats import norm

# ===================
# Part 2: Data Preparation
# ===================
# Sample data for demonstration representing temperature distributions (°C) for two regions
data_region_a = np.array([24.42, 8.26, 8.65, 19.85, 9.13, 24.72, 12.93, 11.26, 24.61, 22.4, 24.34, 19.53, 10.69, 24.55, 13.66, 19.01, 19.74, 14.22, 18.07, 19.61, 16.88, 9.5, 16.49, 21.63, 11.53, 14.25, 12.82, 24.25, 18.36, 17.04, 11.15, 17.7, 11.63, 15.16, 11.82, 18.38, 17.88, 13.96, 16.98, 9.53, 7.54, 17.2, 15.83, 18.18, 26.92, 19.72, 10.44, 20.59, 8.42, 12.69])
data_region_b = np.array([24.66, 33.57, 21.28, 20.87, 24.51, 21.68, 30.63, 19.6, 19.26, 22.81, 22.51, 34.65, 29.75, 25.44, 18.87, 29.22, 20.0, 17.28, 30.94, 26.58, 29.6, 26.59, 29.28, 21.74, 19.83, 28.41, 20.98, 21.55, 22.72, 25.09, 23.23, 18.13, 21.78, 13.88, 28.13, 16.99, 19.48, 25.26, 21.3, 32.72, 18.54, 26.34, 24.8, 19.16, 27.62, 24.14, 28.86, 29.12, 35.82, 31.68])

# Labels and Plot Types
ax1_label = "Region A"
ax2_label = "Region B"
ax1_text = "Mean Temp A"
ax2_text = "Mean Temp B"

# Axes Limits and Labels
xlabel_value = "Temperature (°C)"
ylabel_value = "Density"
xticks_values = [0, 5, 10, 15, 20, 25, 30, 35, 40]
xlim_values = [-5, 45]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(
    figsize=(10, 8)
)  # Adjusted to match the original image's dimensions

# Plot histograms
ax.hist(data_region_a, bins=15, density=True, alpha=0.7, color="#1982c4", label=ax1_label)
ax.hist(data_region_b, bins=15, density=True, alpha=0.7, color="#ff595e", label=ax2_label)

# Plot normal distributions
xmin, xmax = ax.get_xlim()
x = np.linspace(xmin, xmax, 100)
p_region_a = norm.pdf(x, np.mean(data_region_a), np.std(data_region_a))
p_region_b = norm.pdf(x, np.mean(data_region_b), np.std(data_region_b))
ax.plot(x, p_region_a, color="#7bc8f6", linewidth=3)
ax.plot(x, p_region_b, color="#f87469", linewidth=3)

# Add dashed lines at mean
ax.axvline(np.mean(data_region_a), color="black", linestyle="dashed")
ax.axvline(np.mean(data_region_b), color="black", linestyle="dashed")

# Add text labels for dashed lines
ax.text(
    np.mean(data_region_a) + 1.5,
    ax.get_ylim()[1] - 0.01,
    ax1_text,
    ha="center",
    va="top",
    fontsize=18,
)
ax.text(
    np.mean(data_region_b) + 1.5,
    ax.get_ylim()[1] - 0.005,
    ax2_text,
    ha="center",
    va="top",
    fontsize=18,
)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_xticks(xticks_values)
ax.set_xlim(xlim_values)

# Add legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig('CB_1.pdf', bbox_inches='tight')
