import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Sample (x,y) for the scatter plot
data = {
    "Low": [[np.random.randint(0, 10), np.random.rand() + 20] for _ in range(10)],
    "Middle": [[np.random.randint(10, 20), np.random.rand() + 25] for _ in range(2)],
    "High": [[np.random.randint(20, 30), np.random.rand() + 30] for _ in range(10)],
}

line_x = np.array([0, 5, 10, 15, 20, 25, 30])
line_y = np.array([20, 22, 24, 26, 28, 30, 32])

colors = ["#3171ad", "#d39334", "#469c76"]  # Use HEX color codes for muted colors
labels = ["Low", "Middle", "High"]
correlation = 0.65
xlabel = "Temperature (°C)"
ylabel = "Precipitation (mm)"
legend_title = "Precipitation Intensity"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create scatter plot
plt.figure(figsize=(7, 5))  # Adjust figure size to match original image dimensions

for key in data:
    x = [item[0] for item in data[key]]
    y = [item[1] for item in data[key]]
    plt.scatter(x, y, color=colors[labels.index(key)], label=key)

# Add regression line
plt.plot(line_x, line_y, color="black")

# Add shaded area for standard deviation
std_dev = 0.5
plt.fill_between(line_x, line_y - std_dev, line_y + std_dev, color="black", alpha=0.1)

# Add legend inside the plot area
plt.legend(title=legend_title, loc="lower right")

# Add correlation text with a box inside the plot area
plt.text(line_x[-2], line_y[-2], f"Correlation: {correlation:.2f}", fontsize=9)

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)

plt.yticks(np.arange(line_y.min(), line_y.max() + 2, 2))

# Set grid
plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig('CB_10.pdf', bbox_inches='tight')
