import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Sample data (replace with actual data)
traffic_flow_weekday = np.random.normal(1400, 200, 1000)
traffic_flow_weekend = np.random.normal(1000, 200, 1000)

min_bin = min(min(traffic_flow_weekday), min(traffic_flow_weekend))
max_bin = max(max(traffic_flow_weekday), max(traffic_flow_weekend))

bins = np.linspace(min_bin, max_bin, 30)
bin_width = bins[1] - bins[0]
labels = ["Weekday Traffic", "Weekend Traffic"]
legend_title = "Traffic Type"
title = "Traffic Flow Distribution"
xlabel = "Traffic Flow (vehicles per hour)"
ylabel = "Frequency"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
figure = plt.figure(figsize=(10, 6))

# Create histogram
count_weekday, bins_weekday, _ = plt.hist(
    traffic_flow_weekday,
    bins=bins,
    color="#a7c4f2",
    alpha=0.7,
    label=labels[0],
    edgecolor="black",
    linewidth=1.25,
)
count_weekend, bins_weekend, _ = plt.hist(
    traffic_flow_weekend,
    bins=bins,
    alpha=0.7,
    color="#fdabd2",
    label=labels[1],
    edgecolor="black",
    linewidth=1.25,
)

# Create line plot on top of the histogram and set edge color
plt.plot(bins_weekday[:-1] + bin_width * 0.5, count_weekday, color="#568ce6", linewidth=1.5)
plt.plot(bins_weekend[:-1] + bin_width * 0.5, count_weekend, color="#fc5fa9", linewidth=1.5)

# Add legend, title, and labels
plt.legend(loc="upper left", title=legend_title)
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig('CB_14.pdf', bbox_inches='tight')
