import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for pie chart
pie_labels = ["Excellent", "Good", "Poor"]
pie_sizes = [60.0, 30.0, 10.0]
pie_counts = [120, 60, 20]
pie_colors = ["#FF6384", "#36A2EB", "#FFCE56"]

# Data for stacked bar chart
bar_labels = ["High Blood Pressure", "Diabetes", "Heart Disease"]
bar_sizes = [50.0, 35.0, 15.0]
bar_counts = [50, 35, 15]
bar_colors = ["#FF9F40", "#FF6384", "#4BC0C0"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(8, 4))
# Pie chart
ax1.pie(
    pie_sizes,
    labels=pie_labels,
    colors=pie_colors,
    autopct=lambda p: "{:.1f}%\n({})".format(p, int(round(p * sum(pie_counts) / 100))),
    startangle=140,
)
ax1.axis("equal")  # Equal aspect ratio ensures that pie is drawn as a circle.

# Stacked bar chart
bar_positions = [0]  # Single bar at position 0
bottom = 0  # Initial bottom is 0 for the first bar segment

for size, color, count, bar_label in zip(bar_sizes, bar_colors, bar_counts, bar_labels):
    ax2.bar(
        bar_positions,
        [size],
        color=color,
        edgecolor=None,
        bottom=[bottom],
        label=bar_label,
        width=0.5,
    )
    # Calculate the middle position for the text
    mid_pos = bottom + (size / 2)
    # Add text annotation inside the bar
    ax2.text(
        0,
        mid_pos,
        "{}% ({})".format(size, count),
        color="black",
        ha="center",
        va="center",
    )
    bottom += size  # Update bottom for the next bar segment

ax2.set_ylim(0, 100)
ax2.set_xlim(-0.5, 0.5)  # Narrow x-axis limits to make the single bar more visible
ax2.set_xticks([])  # Remove x-ticks as they are not necessary
ax2.set_yticks(range(0, 101, 10))  # Set y-ticks to show percentage
ax2.set_yticklabels(["{}%".format(i) for i in range(0, 101, 10)])
ax2.legend(loc="upper right", bbox_to_anchor=(1.5, 1))
ax2.set_axis_off()

# set the title
ax2.set_title("Incomparable")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig('CB_15.pdf', bbox_inches='tight')
