import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
methods = ["Method A", "Method B", "Method C", "Method D"]
average_scores = [0.785, 0.823, 0.856, 0.902]
pass_rates = [0.76, 0.83, 0.88, 0.95]

# Axes Limits and Labels
ax1_title = "Average Test Scores by Method"
ax1_ylim = [0.70, 1.00]
ax1_ylabel = "Scores"
ax2_title = "Pass Rates by Method"
ax2_ylim = [0.60, 1.00]
ax2_ylabel = "Rates"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 4))

# Bar chart for Average Test Scores
ax1.bar(methods, average_scores, color="skyblue")
ax1.plot(methods, average_scores, marker="o", color="blue")
for i, score in enumerate(average_scores):
    ax1.text(i, score, f"{score*100:.2f}%", ha="center", va="bottom")
ax1.set_title(ax1_title)
ax1.set_ylim(ax1_ylim)
ax1.set_ylabel(ax1_ylabel)
# set ax1 background color
ax1.set_facecolor("#f5f5f5")

# Bar chart for Pass Rates
ax2.bar(methods, pass_rates, color="skyblue")
ax2.plot(methods, pass_rates, marker="o", color="red")
for i, rate in enumerate(pass_rates):
    ax2.text(i, rate, f"{rate*100:.2f}%", ha="center", va="bottom")
ax2.set_title(ax2_title)
ax2.set_ylim(ax2_ylim)
ax2.set_ylabel(ax2_ylabel)
ax2.set_facecolor("#f5f5f5")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig('CB_17.pdf', bbox_inches='tight')
