import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data
years = np.array([2010, 2012, 2014, 2016, 2018, 2020, 2022, 2024])
fiber_optic_speed = np.array([20, 40, 60, 80, 100, 150, 200, 250])  # Mbps
dsl_speed = np.array([10])
error = np.array([2])
labels = ["Fiber Optic", "DSL"]
xlabel = "Year"
ylabel = "Average Speed (Mbps)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(6, 4))  # Adjusting figure size to 432x288 pixels

# Fiber Optic Internet Speed
ax.plot(
    years,
    fiber_optic_speed,
    marker="o",
    color="blue",
    label=labels[0],
)
ax.fill_between(
    years, fiber_optic_speed - 5, fiber_optic_speed + 5, color="#e1eff4"
)

# DSL Internet Speed with error
ax.errorbar(
    years[0],
    dsl_speed,
    yerr=error,
    fmt="o",
    color="red",
    label=labels[1],
    capsize=3,
)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_xlim(2008, 2026)
ax.set_ylim(0, 260)  # Adjusted y-axis limit to match the new data range
ax.legend(loc="lower right")
ax.grid(True)
ax.set_xticks(years)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig('CB_18.pdf', bbox_inches='tight')