import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
em_7b_trainable_parameter_size = [8, 20, 25, 40, 173]
EM_7B = [51.49, 54.18, 68.46, 74.55, 78.32]
em_13b_trainable_parameter_size = [73]
EM_13B = [79.64]
models_7b = ["Carbon Lite", "Carbon Attn", "Carbon FFN", "Carbon", "Carbon Plus"]
models_13b = ["Carbon Large"]
labels = ["LLaMA 7B", "LLaMA 13B"]
ylabel = "EM (%)"
xlabel = "Trainable Parameter Size (M)"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(
    figsize=(7, 7)
)  # Adjusting figure size to match original dimensions
ax.plot(
    em_7b_trainable_parameter_size,
    EM_7B,
    "o-r",
    label=labels[0],
    marker="o",
    markersize=5,
)
ax.plot(
    em_13b_trainable_parameter_size,
    EM_13B,
    "o-b",
    label=labels[1],
    marker="*",
    markersize=10,
)

# Annotating data points
for i, txt in enumerate(models_7b):
    ax.annotate(
        f"{EM_7B[i]:.2f}\n{txt}",
        (em_7b_trainable_parameter_size[i], EM_7B[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )

for i, txt in enumerate(models_13b):
    ax.annotate(
        f"{EM_13B[i]:.2f}\n{txt}",
        (em_13b_trainable_parameter_size[i], EM_13B[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )

# Legend
ax.legend(loc="lower right")

# Labels and Title
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
# ax.set_title('Model Performance by Parameter Size')
ax.set_yticks([50, 55, 60, 65, 70, 75, 80, 85])
ax.set_ylim([48, 85])
ax.set_xlim([-5, 180])

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig('CB_19.pdf', bbox_inches='tight')
