import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Fixing random state for reproducibility
# Transportation-related random data
x = np.random.rand(100) * 40 + 10  # Vehicle speed in km/h
y = np.random.rand(100) * 15 + 5   # Fuel efficiency in km/l
line_x = [15, 25, 35, 45, 55]
line_y = [8, 9, 10, 11, 12]
scatter_name = "Vehicle data"
line_name = "Efficiency trend"
xlabel = "Vehicle speed (km/h)"
ylabel = "Fuel efficiency (km/l)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Start with a square Figure.
fig = plt.figure(figsize=(6, 6))
gs = fig.add_gridspec(
    2,
    1,
    height_ratios=(1, 4),
    left=0.1,
    right=0.9,
    bottom=0.1,
    top=0.9,
    wspace=0.0,
    hspace=0.0,
)
# Create the Axes.
ax = fig.add_subplot(gs[1, 0])
ax_histx = fig.add_subplot(gs[0, 0], sharex=ax)

# Draw the scatter plot and marginals.
# no labels
ax_histx.tick_params(axis="x", labelbottom=False)

# the scatter plot:
ax.scatter(x, y, color="#e3b388", edgecolor="white", s=50, label=scatter_name)

# add a line on ax
ax.plot(
    line_x,
    line_y,
    color="black",
    linewidth=2,
    marker="o",
    markersize=6,
    label=line_name,
)

# draw a diagonal line
ax.plot([10, 60], [5, 20], color="black", linestyle="--")

# now determine nice limits by hand:
binwidth = 5
xymax = max(np.max(np.abs(x)), np.max(np.abs(y)))
lim = (int(xymax / binwidth) + 1) * binwidth
bins = np.arange(10, lim + binwidth, binwidth)
ax_histx.hist(x, bins=bins, color="#d6a3b3", edgecolor="black")

# remove the y-axis labels
ax_histx.set_yticks([])

# remove the top, left, and right spines
ax_histx.spines["top"].set_visible(False)
ax_histx.spines["left"].set_visible(False)
ax_histx.spines["right"].set_visible(False)

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

ax.set_xticks([10, 20, 30, 40, 50, 60])
ax.set_yticks([0, 5, 10, 15, 20])
ax.set_xlim(10, 60)
ax.set_ylim(0, 20)

ax.legend(loc="lower right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('CB_20.pdf', bbox_inches='tight')
