import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0)
np.random.seed(0)

from scipy.stats import norm

# ===================
# Part 2: Data Preparation
# ===================
# Define the data for each subplot using random numbers and normal distribution
total_distance_data = np.random.normal(500, 50, 1000)  # Total Distance Traveled in miles
average_speed_data = np.random.normal(60, 5, 1000)     # Average Speed in mph
fuel_consumption_data = np.random.normal(15, 2, 1000)  # Fuel Consumption in gallons
travel_time_data = np.random.normal(8, 1, 1000)        # Travel Time in hours

titles = ["Total Distance Traveled", "Average Speed", "Fuel Consumption", "Travel Time"]
xlabels = ["Miles", "Miles per hour", "Gallons", "Hours"]
ylabels = ["Probability", "Probability", "Probability", "Probability"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(10, 8))

# Define the subplot grid with reduced space between subplots
grid = plt.GridSpec(2, 2, wspace=0.4, hspace=0.5)

# Total Distance Traveled subplot
ax_total_distance = plt.subplot(grid[0, 0])
ax_total_distance.hist(
    total_distance_data, bins=20, color="#0c279f", edgecolor="black", density=True, linewidth=1
)
ax_total_distance.plot(
    np.sort(total_distance_data),
    norm.pdf(np.sort(total_distance_data), np.mean(total_distance_data), np.std(total_distance_data)),
    color="#3a809d",
)
ax_total_distance.set_title(titles[0])
ax_total_distance.set_xlabel(xlabels[0])
ax_total_distance.set_ylabel(ylabels[0])
ax_total_distance.set_ylim(0, 0.010)
ax_total_distance.text(
    0.7,
    0.8,
    f"$\mu = {np.mean(total_distance_data):.2f}$\n$\sigma = {np.std(total_distance_data):.2f}$",
    transform=ax_total_distance.transAxes,
    fontsize=9,
)

# Average Speed subplot
ax_average_speed = plt.subplot(grid[0, 1])
ax_average_speed.hist(
    average_speed_data,
    bins=20,
    color="#cd6838",
    edgecolor="black",
    density=True,
    linewidth=1,
)
ax_average_speed.plot(
    np.sort(average_speed_data),
    norm.pdf(np.sort(average_speed_data), np.mean(average_speed_data), np.std(average_speed_data)),
    color="#3a809d",
)
ax_average_speed.set_title(titles[1])
ax_average_speed.set_xlabel(xlabels[1])
ax_average_speed.set_ylabel(ylabels[1])
ax_average_speed.set_ylim(0, 0.08)
ax_average_speed.text(
    0.7,
    0.8,
    f"$\mu = {np.mean(average_speed_data):.2f}$\n$\sigma = {np.std(average_speed_data):.2f}$",
    transform=ax_average_speed.transAxes,
    fontsize=9,
)

# Fuel Consumption subplot
ax_fuel_consumption = plt.subplot(grid[1, 0])
ax_fuel_consumption.hist(
    fuel_consumption_data,
    bins=20,
    color="#9cc25c",
    edgecolor="black",
    density=True,
    linewidth=1,
)
ax_fuel_consumption.plot(
    np.sort(fuel_consumption_data),
    norm.pdf(np.sort(fuel_consumption_data), np.mean(fuel_consumption_data), np.std(fuel_consumption_data)),
    color="#3a809d",
)
ax_fuel_consumption.set_title(titles[2])
ax_fuel_consumption.set_xlabel(xlabels[2])
ax_fuel_consumption.set_ylabel(ylabels[2])
ax_fuel_consumption.set_ylim(0, 0.25)
ax_fuel_consumption.text(
    0.7,
    0.8,
    f"$\mu = {np.mean(fuel_consumption_data):.2f}$\n$\sigma = {np.std(fuel_consumption_data):.2f}$",
    transform=ax_fuel_consumption.transAxes,
    fontsize=9,
)

# Travel Time subplot
ax_travel_time = plt.subplot(grid[1, 1])
ax_travel_time.hist(
    travel_time_data, bins=20, color="#f9df4b", edgecolor="black", density=True, linewidth=1
)
ax_travel_time.plot(
    np.sort(travel_time_data),
    norm.pdf(np.sort(travel_time_data), np.mean(travel_time_data), np.std(travel_time_data)),
    color="#3a809d",
)
ax_travel_time.set_title(titles[3])
ax_travel_time.set_xlabel(xlabels[3])
ax_travel_time.set_ylabel(ylabels[3])
ax_travel_time.set_ylim(0, 0.5)
ax_travel_time.text(
    0.7,
    0.8,
    f"$\mu = {np.mean(travel_time_data):.2f}$\n$\sigma = {np.std(travel_time_data):.2f}$",
    transform=ax_travel_time.transAxes,
    fontsize=9,
)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('CB_22.pdf', bbox_inches='tight')