import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
charge_cycles = [110, 190, 320, 560, 1550]
efficiency = [1.19, 1.25, 1.27, 1.29, 1.30]
charge_cycles2 = [550]
efficiency2 = [1.20]

# Labels and Plot Types
label_method1 = "Method 1"
label_method2 = "Method 2"
efficiency_annotations = [
    "1.30\nTest 1",
    "1.21\nTest 2",
    "1.27\nTest 3",
    "1.28\nTest 4",
    "1.29\nTest 5",
]
efficiency2_annotation = "1.19\nTest 6"

# Axes Limits and Labels
xlabel_value = "Number of Charge Cycles"
ylabel_value = "Efficiency (RMSE)"
xticklabels1 = [str(num) for num in charge_cycles]
ylim_values = [1.15, 1.35]
yticks_values = [1.15, 1.20, 1.25, 1.30]
xlim_values = [-100, 1700]
xticks_values = [0, 500, 1000, 1500]
xticklabels2 = ["0", "500", "1000", "1500"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(6, 8))  # Adjust the size to match the original image's dimensions

# Plot the data
ax.plot(charge_cycles, efficiency, "ro-", label=label_method1, linewidth=2)
ax.plot(charge_cycles2, efficiency2, "b*", markersize=10, label=label_method2)

# Annotate the points
for i, txt in enumerate(efficiency_annotations):
    ax.annotate(
        txt,
        (charge_cycles[i], efficiency[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )
ax.annotate(
    efficiency2_annotation,
    (charge_cycles2[0], efficiency2[0]),
    textcoords="offset points",
    xytext=(0, 5),
    ha="center",
    color="black",
    fontsize=10,
)

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=10)
ax.set_ylabel(ylabel_value, fontsize=10)

# Set the legend
legend = ax.legend(fontsize=10)

# Adjust x-axis labels
ax.set_xticks(charge_cycles)
ax.set_xticklabels(xticklabels1, ha="center")
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.set_xlim(xlim_values)
ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels2, ha="center")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig('CB_23.pdf', bbox_inches='tight')

