import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)
from scipy.stats import norm

# ===================
# Part 2: Data Preparation
# ===================
# Sample data for demonstration purposes
x1 = np.linspace(10, 30, 100)
y1 = norm.pdf(x1, 20, 3)
x2 = np.linspace(30, 50, 100)
y2 = norm.pdf(x2, 40, 3)
x3 = np.linspace(50, 70, 100)
y3 = norm.pdf(x3, 60, 3)
labels = ["Route A", "Route B", "Route C"]
xlabel = "Travel Time (minutes)"
ylabel = "Density"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot the distributions
ax.plot(x1, y1, "r--", label=labels[0])
ax.plot(x2, y2, "orange", label=labels[1])
ax.plot(x3, y3, "b:", label=labels[2])

# according to the above distribution and draw histogram for each distribution
# set filled color
ax.hist(np.random.normal(20, 3, 1000), bins=5, density=True, color="pink")
ax.hist(np.random.normal(40, 3, 1000), bins=5, density=True, color="bisque")
ax.hist(np.random.normal(60, 3, 1000), bins=5, density=True, color="lightblue")

# Add annotations
ax.annotate(
    "",
    xy=(20, 0.12),
    xytext=(40, 0.12),
    arrowprops=dict(facecolor="black", arrowstyle="<->"),
)
ax.annotate(
    "",
    xy=(20, 0.14),
    xytext=(60, 0.14),
    arrowprops=dict(facecolor="black", arrowstyle="<->"),
)
ax.annotate(
    "",
    xy=(40, 0.10),
    xytext=(60, 0.10),
    arrowprops=dict(facecolor="black", arrowstyle="<->"),
)

# add text on 30, 0.12
ax.text(30, 0.121, "20", fontsize=12, ha="center")
ax.text(40, 0.141, "40", fontsize=12, ha="center")
ax.text(50, 0.101, "20", fontsize=12, ha="center")

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

ax.set_ylim(0.00, 0.20)
ax.set_yticks([0.00, 0.05, 0.10, 0.15, 0.20])

# Add legend
ax.legend(ncol=3)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig('CB_24.pdf', bbox_inches='tight')
