import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Sample data
cities = [
    "City A",
    "City B",
    "City C",
    "City D",
    "City E",
    "City F",
    "City G",
    "City H",
]
car_usage = [30, 40, 35, 50, 60, 45, 70, 80]
bike_usage = [20, 25, 30, 35, 40, 45, 50, 55]
public_transport = [25, 30, 35, 40, 45, 50, 55, 60]
walking = [25, 20, 25, 30, 35, 40, 45, 50]
yearly_change = [0.05, 0.03, 0.04, 0.02, 0.01, 0.00, -0.01, -0.02]
labels = ["Car Usage", "Bike Usage", "Public Transport", "Walking"]
xlabel = "Cities"
ylabel1 = "Usage Percentage"
ylabel2 = "Yearly Change %"
legend_title = "Transportation Modes"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax1 = plt.subplots(figsize=(8, 5))

# Bar plot
bar_width = 0.2
index = np.arange(len(cities))
ax1.bar(index, car_usage, bar_width, label=labels[0], color="limegreen")
ax1.bar(index + bar_width, bike_usage, bar_width, label=labels[1], color="sandybrown")
ax1.bar(index + 2 * bar_width, public_transport, bar_width, label=labels[2], color="cornflowerblue")
ax1.bar(index + 3 * bar_width, walking, bar_width, label=labels[3], color="plum")

# Line plot
ax2 = ax1.twinx()
ax2.plot(
    cities,
    yearly_change,
    color="orangered",
    marker="o",
    linestyle="-",
    linewidth=2,
    markersize=5,
)

# Annotate yearly change percentages
for i, change in enumerate(yearly_change):
    ax2.annotate(
        f"{change*100:.0f}%",
        (index[i] + bar_width * 1.2, change),
        textcoords="offset points",
        xytext=(0, 0),
        ha="center",
        color="orangered",
    )

# Set labels and title
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel1)
ax2.set_ylabel(ylabel2)

# Set x-axis tick labels
ax1.set_xticks(index + bar_width * 1.5)
ax1.set_xticklabels(cities)

# Add legend
ax1.legend(loc="lower center", ncol=4, bbox_to_anchor=(0.5, -0.3), title=legend_title)
ax1.grid(axis="y")
ax1.set_axisbelow(True)

# set ax2.yticklabels to be percentage
ax2.set_yticklabels([f"{x*100:.0f}%" for x in ax2.get_yticks()])

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig('CB_25.pdf', bbox_inches='tight')