import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
# Setting a seed for reproducibility

# Generating random data to represent the average commute time (in minutes) for different transportation modes
data_bus = np.random.normal(40, 10, 100)  # Bus
data_train = np.random.normal(30, 5, 100)  # Train
data_bike = np.random.normal(25, 8, 100)  # Bike
data_car = np.random.normal(35, 7, 100)  # Car

# Packing the data into a list
data = [data_bus, data_train, data_bike, data_car]
legend_labels = ["Bus", "Train", "Bike", "Car"]
line_label = "Median Commute Time"
ylabel = "Commute Time (Minutes)"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating a box plot
fig, ax1 = plt.subplots(figsize=(10, 6))
bp = ax1.boxplot(
    data, patch_artist=True, notch=False, showfliers=False, positions=[1, 2, 3, 4]
)

# Customizing the boxplot colors
colors = ["#17c3b2", "#ffcb77", "#fe6d73", "#00b4d8"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)
for median in bp["medians"]:
    median.set(color="black", zorder=2)

# Extracting medians for the line graph
medians = [np.median(d) for d in data]

# Creating the line graph on the same axes
ax1.plot(
    [1, 2, 3, 4],
    medians,
    "-*",
    color="black",
    label="Median Commute Time",
    ms=20,
    markerfacecolor="#d90368",
)

# Setting legend for the boxplot
legend_patches = [
    mpatches.Patch(color=color, label=label)
    for color, label in zip(colors, legend_labels)
]
ax1.legend(
    handles=legend_patches
    + [mpatches.Patch(color="#d90368", label=line_label)],
    loc="upper right",
)

# Setting labels for the x-axis
ax1.set_xticklabels(legend_labels)

# Setting the y-axis label
ax1.set_ylabel(ylabel)

# Setting y-axis limits and adding grid lines
ax1.set_ylim(10, 60)
ax1.yaxis.grid(True, which="major", linestyle="--", color="grey", alpha=0.5)

# Removing top and right spines for aesthetics
ax1.spines["top"].set_visible(False)
ax1.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('CB_27.pdf', bbox_inches='tight')