import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Transportation modes
transport_modes = [
    "Automobiles",
    "Bicycles",
    "Buses",
    "Trains",
    "Planes",
    "Ships",
    "Motorcycles",
    "Scooters",
    "Trams",
    "Helicopters",
]

# Number of registered vehicles in 2013 (in thousands)
vehicles_2013 = [50000, 10000, 15000, 20000, 8000, 3000, 7000, 5000, 2000, 1000]
# Number of registered vehicles in 2022 (in thousands)
vehicles_2022 = [55000, 12000, 16000, 22000, 9000, 3500, 7500, 6000, 2500, 1200]
x_label = "Number of Registered Vehicles (in thousands)"
y_label = "Transportation Mode"
ax1_title = "Registered Vehicles in 2013"
ax2_title = "Registered Vehicles in 2022"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (1x2) and shared y-axis
fig, axes = plt.subplots(1, 2, figsize=(10, 5), sharey=True)
colors = ["skyblue", "salmon"]

# Plotting the bar graphs
for i, (vehicles, color) in enumerate(zip([vehicles_2013, vehicles_2022], colors)):
    axes[i].barh(transport_modes, vehicles, color=color, edgecolor="gray")
    axes[i].set_xlabel(x_label)
    # Adding line graph on the same axes
    axes[i].plot(vehicles, transport_modes, "o-", color="#f7b267")

# Adding data labels
for ax, vehicles in zip(axes, [vehicles_2013, vehicles_2022]):
    for index, value in enumerate(vehicles):
        ax.text(value + 50, index, f" {value}", va="center")

# Set labels and titles
axes[0].set_title(ax1_title)
axes[1].set_title(ax2_title)
axes[0].set_ylabel(y_label)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping and overlap
plt.tight_layout()
plt.savefig('CB_29.pdf', bbox_inches='tight')
