import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Sample transportation data
quarters = ["Q1", "Q2", "Q3", "Q4"]
regionA = [1200, 1250, 1300, 1350]
regionB = [1100, 1150, 1200, 1250]
regionC = [900, 950, 1000, 1050]
regionD = [800, 850, 900, 950]
growth = [0.05, 0.20, 0.15, 0.10]

# Errors (e.g., standard deviation)
errorA = [50, 45, 40, 35]
errorB = [55, 50, 45, 40]
errorC = [60, 55, 50, 45]
errorD = [65, 60, 55, 50]
error_growth = [0.02, 0.03, 0.04, 0.01]
labels = ["Region A", "Region B", "Region C", "Region D"]
xlabel = "Quarter"
ylabel1 = "Vehicle Count"
ylabel2 = "Growth %"
legend_title = "Regions"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax1 = plt.subplots(figsize=(8, 6))

# Bar plot with error bars
bar_width = 0.2
index = np.arange(len(quarters))
ax1.bar(
    index,
    regionA,
    bar_width,
    label=labels[0],
    color="limegreen",
    yerr=errorA,
    capsize=5,
    ecolor="gray",
)
ax1.bar(
    index + bar_width,
    regionB,
    bar_width,
    label=labels[1],
    color="sandybrown",
    yerr=errorB,
    capsize=5,
    ecolor="gray",
)
ax1.bar(
    index + 2 * bar_width,
    regionC,
    bar_width,
    label=labels[2],
    color="cornflowerblue",
    yerr=errorC,
    capsize=5,
    ecolor="gray",
)
ax1.bar(
    index + 3 * bar_width,
    regionD,
    bar_width,
    label=labels[3],
    color="plum",
    yerr=errorD,
    capsize=5,
    ecolor="gray",
)

# Line plot with error bars
ax2 = ax1.twinx()
ax2.errorbar(
    index + 1.5 * bar_width,
    growth,
    yerr=error_growth,
    fmt="o-",
    color="#f72585",
    label="Growth",
    linewidth=2,
    markersize=5,
    capsize=5,
)

# Set labels and title
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel1)
ax2.set_ylabel(ylabel2)

# Set x-axis tick labels
ax1.set_xticks(index + 1.5 * bar_width)
ax1.set_xticklabels(quarters)

# Add legends
ax1.legend(loc="lower center", ncol=4, bbox_to_anchor=(0.5, -0.25), title=legend_title)
ax2.legend(loc="upper left", ncol=1)

# Set ax2.yticklabels to be percentage
ax2.set_ylim(0, 0.25)
ax2.set_yticks(np.linspace(0, 0.25, 6))
ax2.set_yticklabels([f"{x*100:.0f}%" for x in ax2.get_yticks()])

# Grid and layout adjustment
ax1.grid(axis="y")
ax1.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('CB_30.pdf', bbox_inches='tight')