import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data
modes = ["Car", "Bus", "Train", "Bike"]
fuel_efficiency = [0.25, 0.50, 0.70, 0.95]
emissions = [0.80, 0.60, 0.40, 0.10]
combined_score = [1.05, 1.10, 1.10, 1.05]
labels = ["Fuel Efficiency (km/l)", "Emissions (kg CO2/km)", "Combined Score (Efficiency + Emissions)"]
xlabel = "Modes of Transportation"
ylabel = "Values"
title = "Fuel Efficiency and Emissions with Combined Score for Different Transportation Modes"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar plot
fig, ax1 = plt.subplots(
    figsize=(10, 6)
)  # Adjust the figsize to match the original image's dimensions

bar_width = 0.35
index = np.arange(len(modes))

bar1 = ax1.bar(index, fuel_efficiency, bar_width, label=labels[0], color="blue")
bar2 = ax1.bar(index + bar_width, emissions, bar_width, label=labels[1], color="green")

# Line plot
ax2 = ax1.twinx()
(line,) = ax2.plot(
    index + bar_width / 2, combined_score, color="red", marker="o", label=labels[2]
)

# Annotate bars with values
for rect, value in zip(bar1, fuel_efficiency):
    height = rect.get_height()
    ax1.text(
        rect.get_x() + rect.get_width() / 2,
        height + 0.01,
        f"{value:.2f}",
        ha="center",
        va="bottom",
    )

for rect, value in zip(bar2, emissions):
    height = rect.get_height()
    ax1.text(
        rect.get_x() + rect.get_width() / 2,
        height + 0.01,
        f"{value:.2f}",
        ha="center",
        va="bottom",
    )

# Labels, title and legend
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.set_title(title)
ax1.set_xticks(index + bar_width / 2)
ax1.set_xticklabels(modes)
ax1.set_ylim(0, 1)
ax1.set_yticks([0.2, 0.4, 0.6, 0.8, 1.0])
ax2.set_ylim(1.00, 1.15)
ax2.set_yticks([1.05, 1.10, 1.15])
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

ax1.yaxis.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust figure size to match original image's dimensions
fig.set_size_inches(10, 6)

# Show plot
plt.tight_layout()
plt.savefig('CB_9.pdf', bbox_inches='tight')