# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np; np.random.seed(0)
# Education data for study hours and performance levels
# Study hours for different student groups
study_hours_group_A = np.random.normal(35, 5, 10)  # Study hours (Group A)
performance_group_A = np.random.normal(80, 10, 10)  # Performance level (Group A)
study_hours_group_B = np.random.normal(45, 8, 10)  # Study hours (Group B)
performance_group_B = np.random.normal(85, 12, 10)  # Performance level (Group B)
study_hours_group_A_B = np.concatenate([study_hours_group_A, study_hours_group_B])
performance_group_A_B = np.concatenate([performance_group_A, performance_group_B])

# Study hours for smaller student groups
study_hours_group_C = np.random.normal(40, 7, 5)  # Study hours (Group C)
performance_group_C = np.random.normal(83, 8, 5)  # Performance level (Group C)
study_hours_group_D = np.random.normal(38, 6, 5)  # Study hours (Group D)
performance_group_D = np.random.normal(78, 9, 5)  # Performance level (Group D)

# Labels and plot limits
xlabel = "Study Hours (per week)"
ylabel = "Performance Level (Percentage)"
main_plot_xlim = [20, 60]
main_plot_ylim = [60, 100]
main_plot_diffline = [[70, 70], [20, 60], [60, 100]]
inset_plot_diffline = [[70, 70], [30, 50], [65, 95]]
annotation_rect_x = [30, 50]
annotation_rect_y = [65, 95]
inset_plot_xlim = [30, 50]
inset_plot_ylim = [65, 95]
plotup1 = [30, 95]
plotdown1 = [30, 65]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))
# Scatter plots
ax1.scatter(study_hours_group_A_B, performance_group_A_B, marker="^", color="#1f77b4", label='Group A & B')
ax1.scatter(study_hours_group_C, performance_group_C, marker="o", color="#ff7f0e", label='Group C')
ax1.scatter(study_hours_group_D, performance_group_D, marker="s", color="#2ca02c", label='Group D')

# Shaded regions
ax1.fill_betweenx(y=[80, main_plot_ylim[1]], x1=main_plot_xlim[0], x2=40, color="red", alpha=0.2)
ax1.fill_betweenx(y=[80, main_plot_ylim[0]], x1=40, x2=main_plot_xlim[1], color="green", alpha=0.2)

# Axis limits and aspect ratio
ax1.set_xlim(main_plot_xlim)
ax1.set_ylim(main_plot_ylim)
ax1.plot(main_plot_diffline[1], main_plot_diffline[0], color="black", lw=0.5)
ax1.plot(main_plot_diffline[0], main_plot_diffline[2], color="black", lw=0.5)

ax1.plot([annotation_rect_x[0], annotation_rect_x[1]], [annotation_rect_y[1], annotation_rect_y[1]], color="black", lw=0.5)
ax1.plot([annotation_rect_x[0], annotation_rect_x[1]], [annotation_rect_y[0], annotation_rect_y[0]], color="black", lw=0.5)
ax1.plot([annotation_rect_x[0], annotation_rect_x[0]], [annotation_rect_y[0], annotation_rect_y[1]], color="black", lw=0.5)
ax1.plot([annotation_rect_x[1], annotation_rect_x[1]], [annotation_rect_y[0], annotation_rect_y[1]], color="black", lw=0.5)

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend(loc="upper right")
ax1.grid(True, which="both", linestyle="--", lw=0.5)

# Scatter plots
ax2.scatter(study_hours_group_A_B, performance_group_A_B, marker="^", color="#1f77b4")
ax2.scatter(study_hours_group_C, performance_group_C, marker="o", color="#ff7f0e")
ax2.scatter(study_hours_group_D, performance_group_D, marker="s", color="#2ca02c")

# Shaded regions
ax2.fill_betweenx(y=[inset_plot_ylim[1], 80], x1=inset_plot_xlim[0], x2=40, color="red", alpha=0.2)
ax2.fill_betweenx(y=[80, inset_plot_ylim[0]], x1=40, x2=inset_plot_xlim[1], color="green", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(inset_plot_xlim)
ax2.set_ylim(inset_plot_ylim)
ax2.plot(inset_plot_diffline[1], inset_plot_diffline[0], color="black", lw=0.5)
ax2.plot(inset_plot_diffline[0], inset_plot_diffline[2], color="black", lw=0.5)
ax2.grid(True, which="both", linestyle="--", lw=0.5)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plotup1)
ax1_plot_down = ax1.transData.transform_point(plotdown1)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(plotup1)
ax2_down = ax2.transData.transform_point(plotdown1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('PIP_12.pdf', bbox_inches='tight')